<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payouts extends Model 
{

    protected $table = 'payouts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'sale_id', 'amount', 'payment_id', 'transaction_id', 'created_by');

    public function getUser()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function getSale()
    {
        return $this->belongsTo('Sales', 'sale_id');
    }

    public function payoutCreatedBy()
    {
        return $this->belongsTo('User', 'created_by');
    }

}